﻿using sinsegye.acpsharp.acp;
using sinsegye.acpsharp.plcopen;
using System;
using System.Net.Sockets;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using static sinsegye.acpsharp.acp.native.ACPNativeMethods;
using static System.Runtime.InteropServices.JavaScript.JSType;


namespace WPF_ACP
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }
        AcpClient _acpClient;
        private void button_Click(object sender, RoutedEventArgs e)
        {
            _acpClient = new AcpClient("192.168.110.137.1.1", 600, ConnectionType.Tcp, false, 500, 500);

            if (_acpClient._ConnState == ConnState.SuccessfulConnection)
            {
                MessageBox.Show("连接成功");
            }
            else
            {
                MessageBox.Show("连接失败");
            }

        }

        class PLCStruct : STRUCT
        { 
            public DWORD child1 = new DWORD();  
            public TIME child2 = new TIME();
        }//结构体类型

        string ReadVar1 = "Application.PLC_PRG.Var1";
        string ReadVar2 = "Application.PLC_PRG.Var2";
        string ReadVar3 = "Application.PLC_PRG.Var3";
        string ReadVar4 = "Application.PLC_PRG.Var4";
        string ReadVar5 = "Application.PLC_PRG.Var5";
        string ReadVar6 = "Application.PLC_PRG.Var6";
        string errorUnmarshal;

        BOOL bool1 = new BOOL();
        INT INT1 = new INT();
        REAL REAL1 = new REAL();
        STRING STRING1 = new STRING();
        ARRAY<INT> intARRAY1 = new ARRAY<INT>(5);
        PLCStruct Struct1 = new PLCStruct();

        private void btnread_Click(object sender, RoutedEventArgs e)
        {
            var ReadError = _acpClient.ReadVar(ReadVar1, bool1, out errorUnmarshal);
            ReadError = _acpClient.ReadVar(ReadVar2, INT1, out errorUnmarshal);
            ReadError = _acpClient.ReadVar(ReadVar3, REAL1, out errorUnmarshal);
            ReadError = _acpClient.ReadVar(ReadVar4, STRING1, out errorUnmarshal);
            ReadError = _acpClient.ReadVar(ReadVar5, intARRAY1, out errorUnmarshal);
            ReadError = _acpClient.ReadVar(ReadVar6, Struct1, out errorUnmarshal);

            Var1.Text = bool1.ToString();
            Var2.Text = INT1.ToString();
            Var3.Text = REAL1.ToString();
            Var4.Text = STRING1;
            Var5.Text = intARRAY1[2].ToString();
            Var6.Text = Struct1.child1.ToString();
            Var7.Text = Struct1.child2.ToString();     

        }

        private void btnMultiRead_Click(object sender, RoutedEventArgs e)
        {
            List<AccessVarModel> accessVarModels = new List<AccessVarModel>();
            AccessVarModel accessVarModel = new AccessVarModel();
            AccessVarModel accessVarMode2 = new AccessVarModel();
            AccessVarModel accessVarMode3 = new AccessVarModel();
            AccessVarModel accessVarMode4 = new AccessVarModel();
            AccessVarModel accessVarMode5 = new AccessVarModel();
            AccessVarModel accessVarMode6 = new AccessVarModel();
            

            accessVarModel.VarName = "Application.PLC_PRG.Var1";
            accessVarModel.VarInstance = bool1;

            accessVarMode2.VarName = "Application.PLC_PRG.Var2";
            accessVarMode2.VarInstance = INT1;

            accessVarMode3.VarName = "Application.PLC_PRG.Var3";
            accessVarMode3.VarInstance = REAL1;

            accessVarMode4.VarName = "Application.PLC_PRG.Var4";
            accessVarMode4.VarInstance = STRING1;

            accessVarMode5.VarName = "Application.PLC_PRG.Var5";
            accessVarMode5.VarInstance = intARRAY1;

            accessVarMode6.VarName = "Application.PLC_PRG.Var6";
            accessVarMode6.VarInstance = Struct1;

            accessVarModels.Add(accessVarModel);
            accessVarModels.Add(accessVarMode2);
            accessVarModels.Add(accessVarMode3);
            accessVarModels.Add(accessVarMode4);
            accessVarModels.Add(accessVarMode5);
            accessVarModels.Add(accessVarMode6);

            var MultiReadError = _acpClient.AccessVars(accessVarModels);


            MultiVar1.Text = accessVarModel.VarInstance.ToString();
            MultiVar2.Text = accessVarMode2.VarInstance.ToString();
            MultiVar3.Text = accessVarMode3.VarInstance.ToString();
            MultiVar4.Text = accessVarMode4.VarInstance.ToString();
            MultiVar5.Text = ((ARRAY<INT>)accessVarMode5.VarInstance)[3].Value.ToString();
            MultiVar6.Text = ((PLCStruct)accessVarMode6.VarInstance).child1.Value.ToString();
            MultiVar7.Text = ((PLCStruct)accessVarMode6.VarInstance).child2.Value.ToString();

        }


        int req = 0;//添加订阅的请求号
        long _Subid = new long(); //用于接受回调函数ID号
        bool isReg = true;//用于初始化注册回调函数
        string[] strings = new string[6];//用于订阅PLC程序变量
        private void btnSub_Click(object sender, RoutedEventArgs e)
        {
            if (isReg)
            {
                var RegError = _acpClient.RegisterRouterEvent(SubCallBack);
                isReg = false;
            }

            strings[0] = "Application.GVL.Var11";
            strings[1] = "Application.GVL.Var12";
            strings[2] = "Application.GVL.Var13";
            strings[3] = "Application.GVL.Var14";
            strings[4] = "Application.GVL.Var15";
            strings[5] = "Application.GVL.Var16";

            var AddSubError = _acpClient.AddBatchSubVar(strings, req, 15);
        }

        BOOL Subbool = new BOOL();
        INT Subint = new INT();
        REAL SubReal = new REAL();
        STRING Substring = new STRING();
        ARRAY<BYTE> SubbyteArray = new ARRAY<BYTE>(10);
        PLCStruct Substruct= new PLCStruct();
        private void SubCallBack(ValueChangeDates dates)
        {
            _Subid = dates.subid;

            foreach (var item in dates.ValueChangeDateList) 
            {
                if (item.VarName == "Application.GVL.Var11")
                {
                    Subbool.Unmarshal(item.Bytes);
                    Application.Current?.Dispatcher.InvokeAsync(new Action(() =>
                    {
                        SubVar1.Text = Subbool.ToString();
                    }));
                }
                if (item.VarName == "Application.GVL.Var12")
                {
                    Subint.Unmarshal(item.Bytes);
                    Application.Current?.Dispatcher.InvokeAsync(new Action(() =>
                    {
                        SubVar2.Text = Subint.ToString();
                    }));
                }
                if (item.VarName == "Application.GVL.Var13")
                {
                    SubReal.Unmarshal(item.Bytes);
                    Application.Current?.Dispatcher.InvokeAsync(new Action(() =>
                    {
                        SubVar3.Text = SubReal.ToString();
                    }));
                }
                if (item.VarName == "Application.GVL.Var14")
                {
                    Substring.Unmarshal(item.Bytes);
                    Application.Current?.Dispatcher.InvokeAsync(new Action(() =>
                    {
                        SubVar4.Text = Substring.ToString();
                    }));
                }
                if (item.VarName == "Application.GVL.Var15")
                {
                    SubbyteArray.Unmarshal(item.Bytes);
                    Application.Current?.Dispatcher.InvokeAsync(new Action(() =>
                    {
                        SubVar5.Text = SubbyteArray[3].ToString();
                    }));
                }
                if (item.VarName == "Application.GVL.Var16")
                {
                    Substruct.Unmarshal(item.Bytes);
                    Application.Current?.Dispatcher.InvokeAsync(new Action(() =>
                    {
                        SubVar6.Text = Substruct.child1.ToString();
                        SubVar7.Text = Substruct.child2.ToString();
                    }));
                }

            }

        }

        private void btnUnSub_Click(object sender, RoutedEventArgs e)
        {
            var UnSubError = _acpClient.DelBatchSubVar(_Subid);
        }

        private void ValueWrite(object sender, RoutedEventArgs e)
        {
            TextBox tb = (TextBox)sender;

            if (tb.Name == "Var1")
            {
                bool.TryParse(Var1.Text, out bool boolwrite);//将Text控件Var1的文本内容转成bool类型存入boolwrite变量
                bool1.Value = boolwrite;//将boolwrite赋值给IplcOpenType类型的实例bool1
                var WriteError = _acpClient.WriteVar(ReadVar1, bool1, out errorUnmarshal);//写入变量
            }
            else if (tb.Name == "Var2")
            {
                short.TryParse(Var2.Text, out short shortwrite);
                INT1.Value = shortwrite;
                var WriteError = _acpClient.WriteVar(ReadVar2, INT1, out errorUnmarshal);
            }
            else if(tb.Name == "Var3")
            {
                float.TryParse(Var3.Text, out float floatwrite);
                REAL1.Value = floatwrite;
                var WriteError = _acpClient.WriteVar(ReadVar3, REAL1, out errorUnmarshal);
            }
            else if (tb.Name == "Var4")
            {
                STRING1.Value = Var4.Text.Replace("\0", "");
                var WriteError = _acpClient.WriteVar(ReadVar4, STRING1, out errorUnmarshal);
            }
            else if (tb.Name == "Var5")
            {
                var ReadError = _acpClient.ReadVar(ReadVar5, intARRAY1, out errorUnmarshal);
                short.TryParse(Var5.Text, out short intArray2write);
                intARRAY1[2].Value = intArray2write;
                var WriteError = _acpClient.WriteVar(ReadVar5, intARRAY1, out errorUnmarshal);
            }
            else if (tb.Name == "Var5")
            {
                var ReadError = _acpClient.ReadVar(ReadVar5, intARRAY1, out errorUnmarshal);//读取数组
                short.TryParse(Var5.Text, out short intArray2write);//将文本转换为int类型
                intARRAY1[2].Value = intArray2write;//修改数组[2]
                var WriteErrore = _acpClient.WriteVar(ReadVar5, intARRAY1, out errorUnmarshal);//写入
            }
            else if (tb.Name == "Var6")
            {
                var ReadError = _acpClient.ReadVar(ReadVar6, Struct1, out errorUnmarshal);//读取结构体
                uint.TryParse(Var6.Text, out uint StuctChild1write);//将文本转换为成员1类型
                Struct1.child1.Value = StuctChild1write;//修改成员1的值
                var WriteError = _acpClient.WriteVar(ReadVar6, Struct1, out errorUnmarshal);//写入
            }
            else if (tb.Name == "Var7")
            {
                var ReadError = _acpClient.ReadVar(ReadVar6, Struct1, out errorUnmarshal);//读取结构体
                TimeSpan timechange= new TimeSpan();  //新建TimeSpan类型用于接收修改值
                TimeSpan.TryParse(Var7.Text,out timechange);//将Text文本转成TimeSpan类型
                Struct1.child2.Value = timechange;//赋值结构体成员2
                var WriteError = _acpClient.WriteVar(ReadVar6, Struct1, out errorUnmarshal);//写入
                
            }

        }


    }
}